---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-Executor Heap Histogram（エグゼキュータヒープヒストグラム）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/ui/exec/ExecutorHeapHistogramPage.scala` 行27-89
- E-02: `core/src/main/scala/org/apache/spark/ui/exec/ExecutorsTab.scala` 行27-46
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` No.12
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` No.12
- E-05: `docs/code-to-docs/画面遷移図.md` ExecutorsTab遷移

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは/executors/heapHistogram/ | E-01 行29: WebUIPage("heapHistogram") | ○ |
| C-02 | executorIdパラメータが必須 | E-01 行35-38: パラメータ取得とIllegalArgumentException | ○ |
| C-03 | Rank/Instances/Bytes/Class Name/Moduleの5列テーブル | E-01 行75-81: theadカラム定義 | ○ |
| C-04 | 正規表現でjmap出力をパース | E-01 行32: patternの定義 | ○ |
| C-05 | Module列はJava 9+対応 | E-01 行46,54: pattern match with/without module | ○ |
| C-06 | SparkContext.getExecutorHeapHistogramで取得 | E-01 行41: sc.get.getExecutorHeapHistogram(executorId) | ○ |
| C-07 | エラー時に"Error fetching heap histogram"を表示 | E-01 行86: getOrElse(Text("Error fetching heap histogram")) | ○ |
| C-08 | heapHistogramEnabled設定で画面の有効/無効が決まる | E-02 行35-36,41-43: UI_HEAP_HISTOGRAM_ENABLEDでattachPage制御 | ○ |
| C-09 | Executors一覧から遷移 | E-05: ExecutorsPage --> ExecutorHeapHistogram | ○ |
| C-10 | sortableクラスでカラムソート可能 | E-01 行74: UIUtils.TABLE_CLASS_STRIPED + " sortable" | ○ |
| C-11 | 取得時刻を表示 | E-01 行73: UIUtils.formatDate(time) | ○ |
| C-12 | ヘッダ/セパレータ/Total行はスキップ | E-01 行62-68: caseの_パターン（コメント参照） | ○ |
| C-13 | ページタイトルに"Heap Histogram for Executor {id}"と表示 | E-01 行87: headerSparkPage引数 | ○ |
| C-14 | デフォルトはfalse（無効） | E-02 行35: UI_HEAP_HISTOGRAM_ENABLED | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面が比較的シンプルで、ソースコードとの整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] heapHistogramEnabledのデフォルト値（false）が設定ファイルと一致するか確認
- [ ] 正規表現パターンがjmapの全バージョン出力形式をカバーしているか確認
